/**
  ******************************************************************************
  * @file    system_py32f0xx.h
  * @brief   CMSIS Cortex-M0+ Device Peripheral Access Layer Header File for
  *                    PY32F0xx Device Series
  * @version v1.0.0
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/** @addtogroup CMSIS
  * @{
  */

/** @addtogroup py32f0xx_system
  * @{
  */  
  
/**
  * @brief Define to prevent recursive inclusion
  */
#ifndef __SYSTEM_PY32F0xx_H
#define __SYSTEM_PY32F0xx_H

#ifdef __cplusplus
 extern "C" {
#endif 

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>

/** @addtogroup PY32F0xx_System_Includes
  * @{
  */

/**
  * @}
  */


/** @addtogroup PY32F0xx_System_Exported_types
  * @{
  */
  /* This variable is updated in three ways:
      1) by calling CMSIS function SystemCoreClockUpdate()
      2) by calling HAL API function HAL_RCC_GetSysClockFreq()
      3) each time HAL_RCC_ClockConfig() is called to configure the system clock frequency 
         Note: If you use this function to configure the system clock; then there
               is no need to call the 2 first functions listed above, since SystemCoreClock
               variable is updated automatically.
  */
extern uint32_t SystemCoreClock;            /*!< System Clock Frequency (Core Clock) */

/* Exported constants --------------------------------------------------------*/
extern const uint32_t  AHBPrescTable[16];   /*!< AHB prescalers table values */
extern const uint32_t  APBPrescTable[8];    /*!< APB prescalers table values */
extern const uint32_t  HSIFreqTable[8];     /*!< HSI frequency  table values */

/**
  * @}
  */

/** @addtogroup PY32F0xx_System_Exported_Constants
  * @{
  */

/**
  * @}
  */

/** @addtogroup PY32F0xx_System_Exported_Macros
  * @{
  */

/**
  * @}
  */

/** @addtogroup PY32F0xx_System_Exported_Functions
  * @{
  */
  
extern void SystemInit(void);
extern void SystemCoreClockUpdate(void);
/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif /*__SYSTEM_PY32F0xx_H */

/**
  * @}
  */
  
/**
  * @}
  */  
/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
